package GUI;

import java.awt.Toolkit;
import java.awt.event.MouseEvent;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import baseClass.*;

/**
 *
 * @author jonhnanthan
 */
public class JanelaInicial extends javax.swing.JFrame {

    JFileChooser dialogo = new JFileChooser();

    /**
     * Construtor da janela inicial 
     */
    public JanelaInicial() {
        initComponents();
    }

    /**
     * Inicia os componentes da janela
     */
    @SuppressWarnings("unchecked")
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        bProcurar1 = new javax.swing.JButton();
        areaTexto1 = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        areaTexto2 = new javax.swing.JTextField();
        bProcurar2 = new javax.swing.JButton();
        jButton3 = new javax.swing.JButton();
        bAvacar = new javax.swing.JButton();
        jLabel3 = new javax.swing.JLabel();
        bDefault = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        jLabel1.setText("Arquivo de Estabelecimentos");

        bProcurar1.setText("Procurar");
        bProcurar1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                bProcurar1MouseClicked(evt);
            }
        });

        jLabel2.setText("Arquivo de Opiniões");

        bProcurar2.setText("Procurar");
        bProcurar2.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                bProcurar2MouseClicked(evt);
            }
        });

        jButton3.setText("Fechar");
        jButton3.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jButton3MouseClicked(evt);
            }
        });

        bAvacar.setText("Avançar");
        bAvacar.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                bAvacarMouseClicked(evt);
            }
        });

        jLabel3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/image3101-v2.png"))); // NOI18N

        bDefault.setText("Abrir arquivos default");
        bDefault.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                bDefaultMouseClicked(evt);
            }
        });
        bDefault.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bDefaultActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(310, 310, 310)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addContainerGap())
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLabel2)
                                .addGap(216, 216, 216))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(bDefault)
                                .addGap(18, 18, 18)
                                .addComponent(bAvacar)
                                .addGap(18, 18, Short.MAX_VALUE)
                                .addComponent(jButton3, javax.swing.GroupLayout.DEFAULT_SIZE, 96, Short.MAX_VALUE))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(areaTexto1, javax.swing.GroupLayout.PREFERRED_SIZE, 268, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(bProcurar1, javax.swing.GroupLayout.DEFAULT_SIZE, 128, Short.MAX_VALUE))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(areaTexto2, javax.swing.GroupLayout.PREFERRED_SIZE, 268, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(bProcurar2, javax.swing.GroupLayout.DEFAULT_SIZE, 128, Short.MAX_VALUE)))
                        .addGap(328, 328, 328))))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addGap(190, 190, 190)
                .addComponent(jLabel3, javax.swing.GroupLayout.DEFAULT_SIZE, 695, Short.MAX_VALUE)
                .addGap(160, 160, 160))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(64, Short.MAX_VALUE)
                .addComponent(jLabel3, javax.swing.GroupLayout.PREFERRED_SIZE, 211, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(55, 55, 55)
                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 18, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(9, 9, 9)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(areaTexto1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(bProcurar1))
                .addGap(27, 27, 27)
                .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 18, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(areaTexto2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(bProcurar2))
                .addGap(42, 42, 42)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButton3)
                    .addComponent(bDefault)
                    .addComponent(bAvacar))
                .addGap(63, 63, 63))
        );

        pack();
    }

    private void bDefaultMouseClicked(MouseEvent evt) {
	}

	/**
     * Fecha o programa
     * @param evt
     * 		evento do mouse
     */
    private void jButton3MouseClicked(java.awt.event.MouseEvent evt) {                                      
        System.exit(0);
    }                                     

    /**
     * mostra o caminho do arquivo selecionado
     * @param evt
     * 		evento do mouse
     */
    private void bProcurar1MouseClicked(java.awt.event.MouseEvent evt) {                                        
        int resultado = dialogo.showOpenDialog(this);
        if (resultado == JFileChooser.APPROVE_OPTION){
            areaTexto1.setText(dialogo.getSelectedFile().toString());
        }
    }                                       

    /**
     * mostra o caminho do arquivo selecionado
     * @param evt
     * 		evento do mouse
     */
    private void bProcurar2MouseClicked(java.awt.event.MouseEvent evt) {                                        
        int resultado = dialogo.showOpenDialog(this);
        if (resultado == JFileChooser.APPROVE_OPTION){
            areaTexto2.setText(dialogo.getSelectedFile().toString());
        }
    }                                       

    /**
     * Botao avancar
     * @param evt
     * 		evento do mouse
     */
    private void bAvacarMouseClicked(java.awt.event.MouseEvent evt) {                                     
        Arquivo arq = new Arquivo();
        int testaEstabelecimento = 0, testaOpiniao = 0;

        try {
            testaEstabelecimento = arq.testaPadraoArquivoDeEstabelecimentos(areaTexto1.getText());
            if (testaEstabelecimento == -1){
            	Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(null, "Arquivo vazio!", "Estabelecimentos", 1);
            } else{
                if (testaEstabelecimento == 0){
                	Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(null, "Arquivo fora do padrao esperado!", "Estabelecimentos", 1);
                }
            }
        } catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Estabelecimentos", 1);
        }

        try {
            arq = new Arquivo();
            testaOpiniao = arq.testaPadraoArquivoDeOpinioes(areaTexto2.getText());
            if (testaOpiniao == -1){
            	Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(null, "Arquivo vazio!", "Opiniões", 1);
            } else{
                if (testaOpiniao == 0){
                	Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(null, "Arquivo fora do padrao esperado!", "Opiniões", 1);
                }
            }
        } catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Opiniões", 1);
        }

        if (testaEstabelecimento == 1 && testaOpiniao == 1){
            setVisible(false);
            new MenuPrincipal(areaTexto1.getText(),areaTexto2.getText()).setVisible(true);
        }

    }                                    

    /**
     * Inicia com os arquivos default
     * @param evt
     * 		evento do botao
     */
    private void bDefaultActionPerformed(java.awt.event.ActionEvent evt) {
        if (bDefault.isEnabled()){
        	this.dispose();
        	new MenuPrincipal("src/Estabelecimentos-v2.data","src/Opinioes-v2.data").setVisible(true);
        }
    }

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new JanelaInicial().setVisible(true);
            }
        });
    }

    private javax.swing.JTextField areaTexto1;
    private javax.swing.JTextField areaTexto2;
    private javax.swing.JButton bAvacar;
    private javax.swing.JButton bDefault;
    private javax.swing.JButton bProcurar1;
    private javax.swing.JButton bProcurar2;
    private javax.swing.JButton jButton3;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;

}
